var document = globalThis.document
const types = {
    isInvisibleWidget: true,
    type: "PY_RUN_WIDGET",
    icon: "icon-toolbox-feature",
    title: "Python代码运行控件",
    version: "1.0.0",
    isGlobalWidget: true,
    properties: [{
        key:"tips",
        label:'详细说明',
        valueType:"string",
        editorType:"TextArea",
        defaultValue:`
         1.控件每执行一块积木至少在开始结束后等待0.1秒,否则出错!\n
         2.Py环境未预设turtle;\n
        `,
    }],
    methods: [{
        key:"runCode",
        label:"运行代码并返回",
        valueType:"string",
        params:[{
            key:"a",
            label:"代码",
            valueType:"string",
            defaultValue:"input()"
        }]
    },{
        key:"getType",
        label:"获取对象对应Py数据类型",
        valueType:"string",
        params:[
            {key:"a",label:"对象",valueType:["string","number","object","array"],defaultValue:""}
        ]
    },{
        key:"runonly",
        label:"直接执行Py代码",
        params:[{
            key:"a",
            label:"代码",
            valueType:"string",
            defaultValue:"print('2')"
        }]
    },{
        key:"loadPack",
        label:"加载模块(无turtle,建议悬停鼠标查看)",
        tooltip:`您可在https://pyodide.org/en/stable/usage/packages-in-pyodide.html 左侧Name框中选取模块包加载`,
        params:[
            {key:"a",label:"模块名",valueType:"string",defaultValue:""}
        ]
    }],
    events: [{
        key:"err",
        label:"出现错误时",
        params:[
            {key:"erl",label:"错误消息",valueType:"string"}
        ]
    }],
};

class Widget extends InvisibleWidget {
   
    constructor(props) {
        super(props);
        this.environment = undefined
   var s =  document.createElement("script")
   s.src = "https://unpkg.com/pyodide@0.23.4/pyodide.js";
   document.body.appendChild(s)
s.onload = () =>{
     globalThis.loadPyodide().then(e =>{
        this.environment = e
     })
    globalThis.console.log = (e) =>{
        this.widgetLog("Python代码输出："+e)
    }
    } 
   
    }

    runCode(a = ""){

        try{
          if(this.environment){
            return (this.environment.runPython(a)).toString()
          }
        }catch(e){
            this.widgetError(e.message)
          this.emit("err",e.message)
        }

    }

    getType(a){

        if(this.environment){
          if((this.environment.toPy(a)) instanceof this.environment.ffi.PyProxy){
            return (this.environment.toPy(a)).type
          }else{
            switch(typeof this.environment.toPy(a)){
                case "string":
                    return "str";
                case "number":
                    if(Number.isInteger(this.environment.toPy(a))){
                        return "int"
                    }else{
                        return "float"
                    }
                case "boolean":
                    return "bool"
                default:
                    if(this.environment.toPy(a) === undefined||this.environment.toPy(a) === null){
                        return "None"
                    }
            }
          }
        }

    }

    runonly(a){

        try{
        if(this.environment)this.environment.runPython(a)
        }catch(e){
            this.widgetError(e.message)
            this.emit("err",e.message)
        }

    }

    loadPack(name){

            try{
                if(this.environment)this.environment.loadPackage(name)
            }catch(e){
                this.widgetError(e.message)
            this.emit("err",e.message)
            }

    }


}

exports.types = types;
exports.widget = Widget;
